//　hantei.js 判定
document.getElementById("html_hantei").addEventListener("click", soroi_hantei_test);

//そろい判定の  テスト用配列
const test_ar0 = [ 0,0,0,0,0,0,0,0,0];
const test_ar1 = [ 1,2,3,4,5,6,7,8,9];
const test_ar2 = [ 2,5,8,9,6,3,7,4,1];
const test_ar3 = [ 4,5,6,7,2,4,5,6,9];
const test_ar4 = [ 9,8,7,6,5,4,3,44,1];


//そろい判定の入力配列
const input_arr = [ 0,0,0,0,0,0,0,0,0];

//そろい判定テスト
function soroi_hantei_test( ){
    // 横方向のそろい判定
    soroi_hantei_yoko( );

    // 縦方向のそろい判定
    soroi_hantei_tate( );

    // ３×３ブロックのそろい判定
    soroi_hantei_block( );

    //碁盤目画面の再描画
    redraw_goban();

    disp_hantei();
}


//ロジック 横方向のフラグ
const flg_yoko = [ 0,0,0,0,0,0,0,0,0];

//ロジック 縦方向のフラグ
const flg_tate = [ 0,0,0,0,0,0,0,0,0];

//ロジック ３×３ブロックのフラグ
const flg_3_3_block  = [0,0,0,0,0,0,0,0,0];

// 横方向のそろい判定
function soroi_hantei_yoko( ){
//    soroi_hantei( test_ar4);
    let i, j, v, r;

    for( j=0; j<KOMA_su; j++){
        for( i=0; i<KOMA_su; i++){
            v = val[j][i];
            if( v > 10){
                v = v - 10;
            }
            input_arr[i] = v;
        }
        r = soroi_hantei( input_arr);
        val[j][KOMA_su] = r;
        flg_yoko[j] = r;
    }
}

// 縦方向のそろい判定
function soroi_hantei_tate( ){
//    soroi_hantei( test_ar4);
    let i, j, v, r;

    for( i=0; i<KOMA_su; i++){
        for( j=0; j<KOMA_su; j++){
            v = val[j][i];
            if( v > 10){
                v = v - 10;
            }
            input_arr[j] = v;
        }
        r = soroi_hantei( input_arr);
        val[KOMA_su][i] = r;
        flg_tate[i] = r;
    }
}

// ３×３ブロックのそろい判定
function soroi_hantei_block( ){
    let i, j, k, ii, jj, kk, v, r;

    kk = 0;
    for( jj=0; jj<3; jj++){
        for( ii=0; ii<3; ii++){
            k = 0;
            for( j=0; j<3; j++){
                for( i=0; i<3; i++){
                    v = val[jj*3+j][ii*3+i];
                    if( v > 10){
                        v = v - 10;
                    }
                    input_arr[k] = v;
                    k++;
                }
            }
            r = soroi_hantei( input_arr);
            flg_3_3_block[kk] = r;
            if( kk < 3){
                val[0][KOMA_su+kk+1] = r;
            } else if( kk < 6){
                val[1][KOMA_su+kk-2] = r;
            } else {
                val[2][KOMA_su+kk-5] = r;
            }
            kk++;
        }
    }
}


function soroi_hantei( arr){
    const num_count = [0,0,0,0,0,0,0,0,0,0];
    let i, len, n, ret;
    //print("soroi_hantei");
    len = arr.length;
    //print("len =" + len);

    for( i=0; i<9; i++){
        n = arr[i];
        //print("n=" + n);
        if( n>=0 && n<=9){
            num_count[n]++;
        }
    }
    for( i=0; i<=9; i++){
        n = num_count[i];
        //print(i + ": " + n + "個");
    }

    ret = 1;
    for( i=1; i<=9; i++){
        n = num_count[i];
        if( n != 1){
            ret = 0;
        }
    }
    //print("ret=" + ret);
    return ret;
}