//mouse.js

//マウス処理
function mouse_syori(e){
    let mi, mj;
    let x, y;

    //マウスダウンされた位置のxy座標を得る
    mx = e.offsetX;
    my = e.offsetY;
    //print("x:" + mx + "  y:" + my );

    //マウスダウンされた位置のij座標を得る
    x = (mx - GOBAN_start_x) / KOUSHI_width;
    y = (my - GOBAN_start_y) / KOUSHI_height;
    mi = Math.floor(x);
    mj = Math.floor(y);
    //print("mi:" + mi + "  mj:" + mj );

    if( mj==10){
        if( mi>=0 && mi<=9){
            //セレクト画面のマウス処理
            mouse_select_syori( mi);
        }
    }

    if( mj>=0 && mj<=8){
        if( mi>=0 && mi<=8){
            //碁盤画面のマウス処理
            mouse_goban_syori( mi, mj);
        }
    }
}

//セレクト画面のマウス処理
function mouse_select_syori( mi){
    print("mouse_select_syori");
    //print("mi:" + mi );

    //セレクト番号
    if( mi==9){
        sel_num = 0;
    } else {
        sel_num = mi+1;
    }
    print("sel_num:" + sel_num );

    //セレクト画面を表示する
    disp_select_gamen();

    //セレクト画面にセレクト番号を表示する
    disp_select_number( sel_num);

    redraw_goban();
}

//碁盤画面のマウス処理
function mouse_goban_syori( mi, mj){
    let c;
    print("mouse_goban_syori");
    print("mi:" + mi + "  mj:" + mj );

    c = val[mj][mi];
    //c>10 (問題の原型の値は１０だけゲタがはかしてある）
    // ユーザが変更してはいけないとき)
    if( c >10){
        // 変更しない
    } else {
        //　配列の要素にセレクト番号を入れる
        val[mj][mi] = sel_num;
    }
    //碁盤目画面を表示する
    disp_goban_gamen();

    //　配列の要素を表示する(ｊ行ｉ列)
    disp_hairetu();
    
    //　色を変えて文字を描く
    ctx.fillStyle = MOJI_col2;
    
    c = val[mj][mi];
    //c>10 (問題の原型の値は１０だけゲタがはかしてある）
    // ユーザが変更してはいけないとき)
    if( c > 10){

    } else {
        if( debug_sw==0){   // 通常モードのとき
            if( sel_num>0){
                draw_moji_ij( c, mi, mj);
            }
        } else {            // デバッグモードのとき
            draw_moji_ij( c, mi, mj);
        }
    }
}

