//draw.js
//ゲーム画面の表示関係

//表示関係の初期化
function draw_title(){
    ctx.drawImage(img1, 0, 0, 550, 550);
}

//表示関係の初期化
function init_draw(){
    //表示関係の値の初期化
    init_draw_val();

    //画面の表示クリア
    init_clear_gamen();
    
    //格子の表示
    disp_koushi();

    //碁盤目画面の再描画
    redraw_goban();

    //セレクト画面を表示する
    disp_select_gamen();
}

//碁盤目画面の再描画
function redraw_goban(){
    //表示関係の値の初期化
    init_draw_val();

    //碁盤目画面を表示する
    disp_goban_gamen();

    //碁盤目画面に配列の要素を表示する
    disp_hairetu();
}

//表示関係の値の初期化
function init_draw_val(){
    //画面全体の表示範囲
    GAMEN_start_x = 0;
    GAMEN_start_y = 0;
    GAMEN_width = KOUSHI_ofs_x + KOUSHI_width * (KOMA_su+3);
    GAMEN_height = KOUSHI_ofs_y + KOUSHI_height * (KOMA_su+5);


    //碁盤目の表示範囲
    GOBAN_start_x = KOUSHI_ofs_x;
    GOBAN_start_y = KOUSHI_ofs_y;
    GOBAN_width = KOUSHI_width * KOMA_su;
    GOBAN_height = KOUSHI_height * KOMA_su;

    //セレクト画面の表示範囲
    SELECT_start_x = GOBAN_start_x;
    SELECT_start_y = GOBAN_start_y + GOBAN_height + KOUSHI_height;
    SELECT_width = GOBAN_width + KOUSHI_width;
    SELECT_height = KOUSHI_height;
}

//碁盤目画面を表示する
function disp_goban_gamen(){
    //print("disp_goban_gamen");
 
    //碁盤画面の表示クリア
    clear_goban_gamen();
    //碁盤画面に格子を表示
    disp_goban_koushi();

}

//セレクト画面を表示する
function disp_select_gamen(){
    //print("disp_select_gamen");

    //セレクト画面の表示クリア
    clear_select_gamen();
    //セレクト画面に格子を表示
    disp_select_koushi();
    // セレクト画面に文字列（１２３４５６７８９Ｘ）を描画する
    disp_select_moji();
}

//セレクト画面にセレクト番号を表示する
function disp_select_number( num){
    //print("disp_select_number");
    col = MOJI_col2;
    ctx.fillStyle = col;

    if( num>=1 && num<=9){
        draw_moji_ij( num, num-1, 10);
    } else {
        draw_moji_ij( "X", 9, 10);
    }
}

//画面の表示クリア
function init_clear_gamen(){
    //画面全体の表示クリア
    clear_zentai_gamen();
    //碁盤画面の表示クリア
    clear_goban_gamen();
    //セレクト画面の表示クリア
    clear_select_gamen();
}

//画面全体の表示クリア
function clear_zentai_gamen(){
    ctx.fillStyle = BACK_col1;
    ctx.fillRect( GAMEN_start_x, GAMEN_start_y, GAMEN_width, GAMEN_height);
}

//碁盤画面の表示クリア
function clear_goban_gamen(){
    ctx.fillStyle = BACK_col1;
    ctx.fillRect( GOBAN_start_x, GOBAN_start_y, GOBAN_width+KOUSHI_width*6, GOBAN_height+KOUSHI_height-5);
    ctx.fillStyle = BACK_col2;
    ctx.fillRect( GOBAN_start_x, GOBAN_start_y, GOBAN_width, GOBAN_height);
}

//セレクト画面の表示クリア
function clear_select_gamen(){
    ctx.fillStyle = BACK_col3;
    ctx.fillRect( SELECT_start_x, SELECT_start_y, SELECT_width, SELECT_height);
}

//格子の表示
function disp_koushi(){
    //碁盤画面に格子を表示
    disp_goban_koushi();
    //セレクト画面に格子を表示
    disp_select_koushi();
}

//碁盤画面に格子を表示
function disp_goban_koushi(){
    let i, j;
    let xx, ys, yd;
    let yy, xs, xd;
    let haba;
    ctx.fillStyle = KOUSHI_col1;

    // 縦線を描画する
    ys = GOBAN_start_y;
    yd = GOBAN_height;
    for( i=0; i<=KOMA_su; i++){
        if( i==0 || i==9){
            haba = SEN_haba3;
        } else if( i==3 || i==6){
            haba = SEN_haba2;
        } else {
            haba = SEN_haba1;
        }
        xx = GOBAN_start_x + KOUSHI_width * i;
        ctx.fillRect( xx-haba, ys-haba, haba+haba, yd+haba+haba);
    }
    
    // 横線を描画する
    xs = GOBAN_start_x;
    xd = GOBAN_width;
    for( j=0; j<=KOMA_su; j++){
        if( j==0 || j==9){
            haba = SEN_haba3;
        } else if( j==3 || j==6){
            haba = SEN_haba2;
        } else {
            haba = SEN_haba1;
        }
        yy = GOBAN_start_y + KOUSHI_height * j;
        ctx.fillRect( xs-haba, yy-haba, xd+haba+haba, haba+haba);
    }

}

//セレクト画面に格子を表示
function disp_select_koushi(){
    let i, j;
    let xx, ys, yd;
    let yy, xs, xd;
    let haba;
    ctx.fillStyle = KOUSHI_col2;

    // 縦線を描画する
    ys = SELECT_start_y;
    yd = SELECT_height;
    for( i=0; i<=KOMA_su+1; i++){
        if( i==0 || i==10){
            haba = SEN_haba3;
        } else if( i==9){
            haba = SEN_haba2;
        } else {
            haba = SEN_haba1;
        }
        xx = SELECT_start_x + KOUSHI_width * i;
        ctx.fillRect( xx-haba, ys-haba, haba+haba, yd+haba+haba);
    }
    
    // 横線を描画する
    xs = SELECT_start_x;
    xd = SELECT_width;
    for( j=0; j<=1; j++){
        haba = SEN_haba2;
        yy = SELECT_start_y + KOUSHI_height * j;
        ctx.fillRect( xs-haba, yy-haba, xd+haba+haba, haba+haba);
    }

}

// セレクト画面に文字列（１２３４５６７８９Ｘ）を描画する
function disp_select_moji(){
    let i, j;
    let x_start;
    let y_start;
    let col;

    //print("disp_select_moji");
    col = MOJI_col1;
    ctx.fillStyle = col;

    j = 10;
    for( i=1; i<=KOMA_su; i++){
        draw_moji_ij( i, i-1, j);
    }
    draw_moji_ij( "X", KOMA_su, j);
}

//　文字を描く(ｊ行ｉ列)
function draw_moji_ij( str, i, j){
    let x, y;
    x =  KOUSHI_ofs_y + KOUSHI_width * i;
    y =  KOUSHI_ofs_y + KOUSHI_height * (j+1);
    ctx.font = MOJI_font;
    ctx.fillText( str, x+6, y-4);
}

